import openmc
import copy

from nuscale import fuel_temperature, struct_temperature, coolant_temperature

mats = {}

# 1.5 w/o enrichment fuel (AO1)
mats['A01'] = openmc.Material(name='1.5 w/o enrichment UO2 fuel')
mats['A01'].set_density('sum')
mats['A01'].add_nuclide('U235',3.56456E-04,'ao')
mats['A01'].add_nuclide('U238',2.31116E-02,'ao')
mats['A01'].add_nuclide('O16', 4.69361E-02,'ao')
mats['A01'].temperature = fuel_temperature

# 1.6 w/o enrichment fuel (AO2)
mats['A02'] = openmc.Material(name='1.6 w/o enrichment UO2 fuel')
mats['A02'].set_density('sum')
mats['A02'].add_nuclide('U235',3.80219E-04,'ao')
mats['A02'].add_nuclide('U238',2.30881E-02,'ao')
mats['A02'].add_nuclide('O16', 4.69367E-02,'ao')
mats['A02'].temperature = fuel_temperature

# 2.5 w/o enrichment fuel (BO1)
mats['B01'] = openmc.Material(name='2.5 w/o enrichment UO2 fuel')
mats['B01'].set_density('sum')
mats['B01'].add_nuclide('U235',5.94084E-04,'ao')
mats['B01'].add_nuclide('U238',2.28766E-02,'ao')
mats['B01'].add_nuclide('O16', 4.69414E-02,'ao')
mats['B01'].temperature = fuel_temperature

# 2.6 w/o enrichment fuel (BO2)
mats['B02'] = openmc.Material(name='2.6 w/o enrichment UO2 fuel')
mats['B02'].set_density('sum')
mats['B02'].add_nuclide('U235',6.17846E-04,'ao')
mats['B02'].add_nuclide('U238',2.28531E-02,'ao')
mats['B02'].add_nuclide('O16', 4.69419E-02,'ao')
mats['B02'].temperature = fuel_temperature

# 4.05 w/o enrichment fuel (CO1)
mats['C01'] = openmc.Material(name='4.05 w/o enrichment UO2 fuel')
mats['C01'].set_density('sum')
mats['C01'].add_nuclide('U235',9.62391E-04,'ao')
mats['C01'].add_nuclide('U238',2.25123E-02,'ao')
mats['C01'].add_nuclide('O16', 4.69495E-02,'ao')
mats['C01'].temperature = fuel_temperature

# 4.55 w/o enrichment fuel (CO2)
mats['C02'] = openmc.Material(name='4.55 w/o enrichment UO2 fuel')
mats['C02'].set_density('sum')
mats['C02'].add_nuclide('U235',1.08120E-03,'ao')
mats['C02'].add_nuclide('U238',2.23948E-02,'ao')
mats['C02'].add_nuclide('O16', 4.69521E-02,'ao')
mats['C02'].temperature = fuel_temperature

# 4.55 w/o enrichment fuel mix with gadolinium (CO2 + Gd)
mats['GdC02'] = openmc.Material(name='4.55 w/o enrichment UO2 fuel mix with gadolinium')
mats['GdC02'].set_density('sum')
mats['GdC02'].add_nuclide('U235',9.61347E-04,'ao')
mats['GdC02'].add_nuclide('U238',1.99124E-02,'ao')
mats['GdC02'].add_nuclide('O16', 4.58016E-02,'ao')
mats['GdC02'].add_nuclide('Gd152',5.40541E-06,'ao')
mats['GdC02'].add_nuclide('Gd154',5.89189E-05,'ao')
mats['GdC02'].add_nuclide('Gd155',4.00000E-04,'ao')
mats['GdC02'].add_nuclide('Gd156',5.53243E-04,'ao')
mats['GdC02'].add_nuclide('Gd157',4.22973E-04,'ao')
mats['GdC02'].add_nuclide('Gd158',6.71352E-04,'ao')
mats['GdC02'].add_nuclide('Gd160',5.90811E-04,'ao')
mats['GdC02'].temperature = fuel_temperature

# 2.6 w/o enrichment fuel (CO3)
mats['C03'] = openmc.Material(name='2.6 w/o enrichment CO3 fuel')
mats['C03'].set_density('sum')
mats['C03'].add_nuclide('U235',6.17846E-04,'ao')
mats['C03'].add_nuclide('U238',2.28531E-02,'ao')
mats['C03'].add_nuclide('O16', 4.69419E-02,'ao')
mats['C03'].temperature = fuel_temperature

#Zircaloy Zr-4
mats['zircaloy'] = openmc.Material(name='Zircaloy')
mats['zircaloy'].set_density('sum')
mats['zircaloy'].add_nuclide('Cr50' ,3.29620E-06 )
mats['zircaloy'].add_nuclide('Cr52' ,6.35640E-05 )
mats['zircaloy'].add_nuclide('Cr53' ,7.20760E-06 )
mats['zircaloy'].add_nuclide('Cr54' ,1.79410E-06 )
mats['zircaloy'].add_nuclide('Fe54' ,8.66980E-06 )
mats['zircaloy'].add_nuclide('Fe56' ,1.36100E-04 )
mats['zircaloy'].add_nuclide('Fe57' ,3.14310E-06 )
mats['zircaloy'].add_nuclide('Fe58' ,4.18290E-07 )
mats['zircaloy'].add_nuclide('O16' ,3.07440E-04 )
mats['zircaloy'].add_nuclide('O17' ,1.16800E-07 )
mats['zircaloy'].add_nuclide('Sn112' ,4.67350E-06 )
mats['zircaloy'].add_nuclide('Sn114' ,3.17990E-06 )
mats['zircaloy'].add_nuclide('Sn115' ,1.63810E-06 )
mats['zircaloy'].add_nuclide('Sn116' ,7.00550E-05 )
mats['zircaloy'].add_nuclide('Sn117' ,3.70030E-05 )
mats['zircaloy'].add_nuclide('Sn118' ,1.16690E-04 )
mats['zircaloy'].add_nuclide('Sn119' ,4.13870E-05 )
mats['zircaloy'].add_nuclide('Sn120' ,1.56970E-04 )
mats['zircaloy'].add_nuclide('Sn122' ,2.23080E-05 )
mats['zircaloy'].add_nuclide('Sn124' ,2.78970E-05 )
mats['zircaloy'].add_nuclide('Zr90' ,2.18280E-02 )
mats['zircaloy'].add_nuclide('Zr91' ,4.76010E-03 )
mats['zircaloy'].add_nuclide('Zr92' ,7.27590E-03 )
mats['zircaloy'].add_nuclide('Zr94' ,7.37340E-03 )
mats['zircaloy'].add_nuclide('Zr96' ,1.18790E-03 )
mats['zircaloy'].temperature = struct_temperature

#Inconel
mats['inconel'] = openmc.Material(name='Inconel')
mats['inconel'].set_density('sum')
mats['inconel'].add_nuclide('Cr50' ,7.82390E-04 )
mats['inconel'].add_nuclide('Cr52' ,1.50880E-02 )
mats['inconel'].add_nuclide('Cr53' ,1.71080E-03 )
mats['inconel'].add_nuclide('Cr54' ,4.25860E-04 )
mats['inconel'].add_nuclide('Fe54' ,1.47970E-03 )
mats['inconel'].add_nuclide('Fe56' ,2.32290E-02 )
mats['inconel'].add_nuclide('Fe57' ,5.36450E-04 )
mats['inconel'].add_nuclide('Fe58' ,7.13920E-05 )
mats['inconel'].add_nuclide('Mn55' ,7.82010E-04 )
mats['inconel'].add_nuclide('Ni58' ,2.93200E-02 )
mats['inconel'].add_nuclide('Ni60' ,1.12940E-02 )
mats['inconel'].add_nuclide('Ni61' ,4.90940E-04 )
mats['inconel'].add_nuclide('Ni62' ,1.56530E-03 )
mats['inconel'].add_nuclide('Ni64' ,3.98640E-04 )
mats['inconel'].add_nuclide('Si28' ,5.67570E-04 )
mats['inconel'].add_nuclide('Si29' ,2.88200E-05 )
mats['inconel'].add_nuclide('Si30' ,1.89980E-05 )
mats['inconel'].temperature = struct_temperature

#304L SS
mats['SS'] = openmc.Material(name='SS 304L')
mats['SS'].set_density('sum')
mats['SS'].add_nuclide('Cr50' ,7.67780E-04 )
mats['SS'].add_nuclide('Cr52' ,1.48060E-02 )
mats['SS'].add_nuclide('Cr53' ,1.67890E-03 )
mats['SS'].add_nuclide('Cr54' ,4.17910E-04 )
mats['SS'].add_nuclide('Fe54' ,3.46200E-03 )
mats['SS'].add_nuclide('Fe56' ,5.43450E-02 )
mats['SS'].add_nuclide('Fe57' ,1.25510E-03 )
mats['SS'].add_nuclide('Fe58' ,1.67030E-04 )
mats['SS'].add_nuclide('Mn55' ,1.76040E-03 )
mats['SS'].add_nuclide('Ni58' ,5.60890E-03 )
mats['SS'].add_nuclide('Ni60' ,2.16050E-03 )
mats['SS'].add_nuclide('Ni61' ,9.39170E-05 )
mats['SS'].add_nuclide('Ni62' ,2.99450E-04 )
mats['SS'].add_nuclide('Ni64' ,7.62610E-05 )
mats['SS'].add_nuclide('Si28' ,9.52810E-04 )
mats['SS'].add_nuclide('Si29' ,4.83810E-05 )
mats['SS'].add_nuclide('Si30' ,3.18930E-05 )
mats['SS'].temperature = struct_temperature

#AIC (80-15-5)
mats['AIC'] = openmc.Material(name='AIC (80-15-5)')
mats['AIC'].set_density('sum')
mats['AIC'].add_nuclide('Ag107' ,2.35230E-02 )
mats['AIC'].add_nuclide('Ag109' ,2.18540E-02 )
mats['AIC'].add_nuclide('Cd106' ,3.38820E-05 )
mats['AIC'].add_nuclide('Cd108' ,2.41660E-05 )
mats['AIC'].add_nuclide('Cd110' ,3.39360E-04 )
mats['AIC'].add_nuclide('Cd111' ,3.48210E-04 )
mats['AIC'].add_nuclide('Cd112' ,6.56110E-04 )
mats['AIC'].add_nuclide('Cd113' ,3.32750E-04 )
mats['AIC'].add_nuclide('Cd114' ,7.82520E-04 )
mats['AIC'].add_nuclide('Cd116' ,2.04430E-04 )
mats['AIC'].add_nuclide('In113' ,3.42190E-04 )
mats['AIC'].add_nuclide('In115' ,7.65110E-03 )
mats['AIC'].temperature = struct_temperature

#B4C
mats['B4C'] = openmc.Material(name='B4C')
mats['B4C'].set_density('sum')
mats['B4C'].add_nuclide('B10' ,1.52060E-02 )
mats['B4C'].add_nuclide('B11' ,6.15140E-02 )
mats['B4C'].add_nuclide('C12' ,1.89720E-02 )
mats['B4C'].add_nuclide('C13' ,2.12520E-04 )
mats['B4C'].temperature = struct_temperature

#Helium
mats['He'] = openmc.Material(name='He')
mats['He'].add_nuclide('He3',4.80890E-10)
mats['He'].add_nuclide('He4',2.40440E-04)
mats['He'].temperature = struct_temperature

#Borated Water (Coolant)
mats['coolant'] = openmc.Material(name="soluble boron water")
mats['coolant'].set_density('sum')
mats['coolant'].add_nuclide("H1", 5.02932E-02)
mats['coolant'].add_nuclide("O16", 2.51573E-02)
mats['coolant'].add_nuclide("B10", 8.33778E-06)
mats['coolant'].add_nuclide("B11", 3.35608E-05)
mats['coolant'].temperature = coolant_temperature

mats['h2o'] = openmc.Material(name="h2o")
mats['h2o'].set_density('sum')
mats['h2o'].add_nuclide("H1", 2.0, percent_type='ao')
mats['h2o'].add_nuclide("O16", 1.0, percent_type='ao')
mats['h2o'].temperature = coolant_temperature

mats['Heavy reflector'] = openmc.Material.mix_materials([mats['SS'], mats['coolant']], [0.956, 0.044], 'vo', name='Heavy reflector')
mats['Heavy reflector'].temperature = coolant_temperature

#Bottom nozzle
mats['Bottom nozzle'] = openmc.Material.mix_materials([mats['SS'], mats['coolant']], [ 0.172, 0.828], 'vo', name='Bottom nozzle')
mats['Bottom nozzle'].temperature = coolant_temperature

#Top nozzle
mats['Top nozzle'] = openmc.Material.mix_materials([mats['SS'], mats['coolant']], [ 0.177, 0.823], 'vo' , name='Top nozzle')
mats['Top nozzle'].temperature = coolant_temperature

mats['coolant'].add_s_alpha_beta('c_H_in_H2O')

materials = openmc.Materials(mats.values())

def clone(material):
    """Perform copy of material but share nuclide densities"""
    shared_mat = copy.copy(material)
    shared_mat.id = None
    return shared_mat
